class twitch_graphite_web_db::config inherits twitch_graphite_web_db {

  file { "/etc/postgresql/9.1/main/private":
    ensure => 'directory',
    owner  => 'postgres',
    group  => 'postgres',
    mode   => '0750',
  }

  twitch_sandstorm_agent::template { "graphite-web-password":
    destination     => "/etc/postgresql/9.1/main/private/graphite-web-password.sql",
    restart_command => "sudo -u postgres psql < /etc/postgresql/9.1/main/private/graphite-web-password.sql",
    contents        => file("${module_name}/graphite-web-password.sql"),
    require         => File['/etc/postgresql/9.1/main/private']
  }

}
