class twitch_graphite_web_db::install inherits twitch_graphite_web_db {

  class { 'postgresql::server':
    listen_addresses => '*'
  }

  postgresql::server::db { 'graphite':
    user             => 'graphite',
    password         => "not_used", # this won't get used because we declare the role below
    require          => Class['postgresql::server']
  }

  postgresql::server::role { 'graphite':
    before        => Postgresql::Server::Db['graphite'],
  }

  postgresql::server::pg_hba_rule { "allow graphite user":
    description => "Allow the graphite user access to the graphite DB",
    type        => "host",
    user        => "graphite",
    database    => "graphite",
    address     => "0.0.0.0/0",
    auth_method => "md5",
  }


}
