class twitch_influxdb (
  $repo_location = 'https://repos.influxdata.com/ubuntu',
  $repo = 'stable',
  $apt_key_id = '05CE15085FC09D18E99EFB22684A14CF2582E0C5',
  $apt_key_source = 'https://repos.influxdata.com/influxdb.key',
  $graphite_enabled = true,
) {

  file { '/var/opt':
    ensure => directory,
    owner  => 'root',
    group  => 'root',
  }

  file { '/var/opt/influxdb':
    ensure  => directory,
    owner   => 'influxdb',
    group   => 'influxdb',
    mode    => 0755,
    require => [
      Package['influxdb'],
    ],
    notify  => [
      Service['influxdb'],
    ],
  }

  class { 'influxdb::server':
    graphite_enabled => $graphite_enabled,
    config_file      => '/etc/influxdb/influxdb.conf',
    manage_install   => false,
    require          => [
      Package['influxdb'],
    ]
  }

  apt::source { 'influxdb':
    location    => $repo_location,
    release     => $::lsbdistcodename,
    repos       => $repo,
    key         => $apt_key_id,
    key_source  => $apt_key_source,
    include_src => false,
  }

  package { 'influxdb':
    ensure   => present,
    require  => [
      Apt::Source['influxdb'],
    ],
  }

  # https://github.com/influxdata/influxdb/blob/master/services/udp/README.md#a-note-on-udpip-os-buffer-sizes
  sysctl::value { 'net.core.rmem_max':
    value => 8388608,
  }

}
