# Installs and configures Jenkins master servers
class twitch_jenkins::master {
  include twitch_jenkins::apt

  # Configure the Jenkins system
  class { "::jenkins":
    configure_firewall => false,
    # Executor thread management is currently disabled due to security issues
    # To get it working, we need to grant the `Overall/RunScripts` permission
    # to the `anonymous` user
    #executors          => 0,
    repo               => false,
    require            => Apt::Source["jenkins"],
  }

  # The `jenkins` class creates a `jenkins` user
  # We need this user to be in the `shadow` group in order to use PAM auth
  exec { "usermod -aG shadow jenkins":
    unless  => "cat /etc/group | grep shadow | grep -q jenkins",
    require => Class["::jenkins"],
  }

  # Install the Swarm plugin
  class { "::jenkins::master":
    # This parameter refers to the version of Swarm, not Jenkins
    version => "1.24",
  }

  # Slaves need to connect to the master via PAM
  # Create a local account for this purpose
  user { "jenkins-slave":
    ensure     => present,
    managehome => true,
    # pass: twitch/systems/jenkins/jenkins-slave-system-user
    password   => '$6$EiNnFTYw$iVfMY.4g.V6jPJWVvuRK/W9i/.sAEa38h8MiwI3dHBDCZwVZiZdI2I85JhMP3HNGh0xozElh5uJEt.wxVzEbm0',
  }

  # Configure our stored jobs
  #class { "::twitch_jenkins_master::jobs":
  #  require => Class["::jenkins"],
  #}
}
