# Installs and configures Jenkins slave servers
class twitch_jenkins::slave {
  include twitch_jenkins::apt

  # Run one executor thread for every two cores on the node
  $executor_thread_count = $::processorcount / 2  #/# vim-puppet bugs out on /

  # Configure Jenkins
  class { '::jenkins::slave':
    executors => $executor_thread_count,
    masterurl => 'http://jenkins-master-demo.internal.justin.tv:8080',
    ui_user   => 'jenkins-slave',
    ui_pass   => 'B2Y6Hc7CxC52EPz8RNDMyzzJ2EPHT4hD',
    require   => Apt::Source['jenkins'],
  }

  # Virtualbox is used to start virtual machines for integration tests
  # `twitch_virtualbox` is our wrapper module (to avoid `apt` duplicates)
  class { 'twitch_virtualbox': }

  # Vagrant is used to orchestrate Virtualbox
  package { 'vagrant':
    ensure  => '1:1.7.2',
    require => Class['twitch_virtualbox'],
  }

  # These packages are used to execute tests against live instances
  package { 'rake':
    ensure => installed,
  }
  package { 'rspec':
    ensure   => installed,
    provider => 'gem',
  }
  package { 'puppet-lint':
    ensure   => '1.1.0',
    provider => 'gem',
  }
  # package { "serverspec":
  #   ensure   => installed,
  #   provider => "gem",
  # }

  # PyYAML is used to validate Hiera syntax
  python::pip { 'PyYAML':
    ensure => present,
  }
}
