class twitch_kibana4::monitoring  {
  # We're monitoring the kibana process itself, but not the Apache service that
  # sits in front of it. This is because Apache has LDAP auth, but we don't have
  # a nagios user for use with monitoring. I'd rather for the kibana
  # process responding to HTTP requests than apache requesting auth.

  # TODO: Make a nagios user for monitoring purposes.
  twitch_nagios::service {'kibana4_http':
    is_nrpe     => true,
    command     => "check_http -H localhost -p ${twitch_kibana4::port}",
    description => 'Kibana HTTP',
    use         => 'generic-systems-service',
  }

  twitch_nagios::service {'kibana4_proc':
    is_nrpe     => true,
    command     => 'check_procs -u kibana -a node -c 1:1',
    description => 'Kibana Process',
    use         => 'generic-systems-service',
  }
}
