class twitch_kibana4::vhost  {
  class { 'apache':
    default_vhost => false,
  }

  # Temporary. Redirect old hostname to the new one in case anyone has bookmarks
  apache::vhost { 'syslog.prod.us-west2.justin.tv':
    servername      => 'syslog.prod.us-west2.justin.tv',
    port            => '80',
    docroot         => '/var/www/redirect',
    redirect_status => 'permanent',
    redirect_dest   => 'https://syslog.internal.twitch.tv/',
    priority        => '99'
  }

  $_cert_name = 'wildcard.internal.twitch.tv'

  twitch_certificate { $_cert_name:
    sandstorm_cert_key => $twitch_kibana4::ssl_cert_sandstorm_key,
    sandstorm_priv_key => $twitch_kibana4::ssl_key_sandstorm_key,
    notify             => Service['httpd'],
  }

  apache::vhost { $twitch_kibana4::vhost_name:
    docroot  => '/var/www/html',
    port     => 80,
    rewrites => [
      {
        comment      => 'Force SSL',
        rewrite_cond => ['%{HTTPS} off'],
        rewrite_rule => ['.* https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]']
      }
    ]
  }

  apache::vhost { "${twitch_kibana4::vhost_name} ssl":
    servername  => $twitch_kibana4::vhost_name,
    docroot     => '/var/www/html',
    port        => 443,
    proxy_pass  => [
      { 'path' => '/', 'url' => "http://localhost:${twitch_kibana4::port}/"}
    ],
    ssl         => true,
    ssl_cert    => "/etc/ssl/certs/${_cert_name}.pem",
    ssl_key     => "/etc/ssl/private/${_cert_name}.key",
    directories => {
      provider            => 'location',
      path                => '/',
      auth_require        => 'valid-user',
      auth_basic_provider => 'ldap',
      auth_type           => 'basic',
      auth_name           => "LDAP credentials",
      custom_fragment     => "AuthLDAPURL ldaps://${::twitch_core::authentication::ldap::ldap_server}/ou=Users,dc=justin,dc=tv",
    },
  }

  class {'apache::mod::authnz_ldap':
    verifyServerCert => false,
  }
}
