class twitch_logstash::monitoring inherits twitch_logstash {
  # Create nagios checks for the Logstash service
  twitch_nagios::service {'logstash':
    is_nrpe     => true,
    command     => '/usr/lib/nagios/plugins/check_procs -C java -w 1: -c 1:1',
    description => 'Logstash',
    use     => 'generic-systems-service',
  }

  $_graphite_data_file = '/opt/nagios_checks/check_graphite_data.py'
  file {$_graphite_data_file:
    ensure => 'present',
    owner  => 'root',
    group  => 'nagios',
    mode   => '0750',
    source => 'puppet:///modules/twitch_graphite/check_graphite_data.py',
  }

  $_replaced_hostname = regsubst($::fqdn, '\.', '_', 'G')
  $_graphite_host = hiera('twitch_graphite_monitor')
  twitch_nagios::service {'logstash_message_rate':
    is_nrpe     => true,
    command     => "${_graphite_data_file} -u ${_graphite_host} -r -w 20 -c 10 -s 20 -m \"timeShift(stats.counters.syslog.prod.${_replaced_hostname}.messages.rate, '60s')\"",
    description => 'Logstash Message Rate',
    use         => 'generic-systems-service',
  }

  twitch_nagios::service {'TCPListenOverflows':
    is_nrpe     => false,
    command     => "check_graphite_data!0!1!$_graphite_host!aws.prod.servers.$_replaced_hostname.tcp.ListenOverflows",
    description => 'TCP Listen Overflows',
    use         => 'generic-systems-service',
  }
}
