# Populates /etc/hardware/lshw.json for device42-agent
class twitch_lshw {
  package { 'lshw':
    ensure => 'latest',
  }

  file { '/etc/init.d/lshw':
    ensure  => 'present',
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    source  => "puppet:///modules/${module_name}/lshw.init",
    require => Package['lshw'],
  }

  # run `lshw` on boot
  service { 'lshw':
    enable  => true,
    require => File['/etc/init.d/lshw'],
  }

  # In order to ensure that `lshw` runs at least once, we use an `exec` here
  exec { '/etc/init.d/lshw start':
    path    => ['/usr/local/bin', '/usr/bin', '/bin'],
    creates => '/etc/hardware/lshw.json',
    require => File['/etc/init.d/lshw'],
  }
}
