define twitch_monit::check(
  $ensure         = 'present',
  $cwd,
  $pidfile,
  $uid,
  $gid            = undef,
  $command        = undef,
  $start_program  = undef,
  $stop_program   = undef,
  $check_interval = 40,
  $env            = 'PATH=$PATH:/usr/local/bin',
  $service_checks = {},
  $custom_checks  = [],
) {
  require twitch_monit

  # global daemon checks in seconds
  # service checks are based on cycle from daemon interval
  # calculate what the user wants and validate to a reasonable global
  $service_check_interval = $check_interval/$twitch_monit::check_interval

  validate_integer($service_check_interval)
  validate_hash($service_checks)
  validate_array($custom_checks)

  # Since we create our own service, based on monit,
  # we have to use exec to clean up on ensure absent.
  if $ensure == 'present' {
    $_check_ensure   = 'present'
    service { "monit-$name":
      ensure    => $_service_ensure,
      provider  => 'base',
      restart   => "/usr/bin/monit restart $name",
      start     => "/usr/bin/monit start $name",
      status    => "/usr/bin/monit status $name", # might not return exit code
      stop      => "/usr/bin/monit stop $name",
      subscribe => Monit::Check[$name],
    }
  } else {
    $_check_ensure   = 'absent'
    exec { "monit-stop-$name":
      command => "/usr/bin/monit stop $name",
      onlyif  => "test -f ${monit::config_dir}/$name",
      before  => Monit::Check[$name],
    }
  }

  monit::check { $name:
    ensure  => $_check_ensure,
    content => template('twitch_monit/monit_check.erb'),
  }
}
