twitch_nagios
-------------

Sets up a Nagios service.

Auto generation
---------------

This module supports automatically generating puppet configuration from PuppetDB.

For samples of how to define hosts and services, see [servicepuppet-template](https://git-aws.internal.justin.tv/mstith/servicepuppet-template).

Static configuration
--------------------

Optionally, if `twitch_nagios::server::config_repo` is set, this module will
manage a repository of static Nagios configuration files. Simply create a
repository in GitHub, and put the name in that hiera value:

```yaml
twitch_nagios::server::config_repo: 'systems/systems-nagios'
```

This repo can contain any number of .cfg files, all of which will be included.

Updates to the repository will automatically be pulled down by Puppet when it
runs every ~30 minutes.

SSH Key
=======

For automatic repository management to work, you'll need to generate an SSH key
for the `nagios` user on the team's nagios server.

```bash
root@some-nagios-123123:~# su - nagios -s/bin/bash
nagios@some-nagios-123123:~$ ssh-keygen # Use default options
nagios@some-nagios-123123:~$ cat ~/.ssh/id_rsa.pub
```

Then place that key in your team's nagios repository's list of deploy keys.
