#!/usr/bin/ruby


require 'socket'
require 'net/http'
require 'uri'

PORTS = {
  :master_ports => [ 2003, 2009 ],
  :node_ports =>[ 2003, 2009 ],
  :cache_ports =>[ 2104, 2114, 2124, 2134, 2144, 2154, 2164, 2174 ]
}

EXIT_STRING_TO_CODE = {
    'OK' =>  0,
    'WARN' => 1,
    'CRITICAL' =>  2,
    'UNKNOWN' => 3
}

all_errors = []

render_url = "/render?from=-3days&until=now&width=400&height=250&target="+
             "carbon.relays.graphstatsd-6daf90.metricsQueued&_uniq=0.9796982377429823&"+
             "title=carbon.relays.graphstatsd-6daf90.metricsQueued"

def check_sockets(server = ARGV[0])
  errors = []
  PORTS.each_key do |port_type|
    PORTS[port_type].each do |port|
      begin
        socket = TCPSocket.open(server,port)
      rescue
        errors << [server,port]
        next
      end
      socket.close
    end
  end
  errors
end

def check_webfront(path = "/")
  errors = []
  begin
    uri = URI.parse("http://#{ARGV[0]}#{path}")
    req = Net::HTTP::Get.new(uri.path)
    req.add_field('Host','graphite.internal.justin.tv')
    response = Net::HTTP.new(uri.host,80).start do |http|
      http.request req
    end
  rescue Exception => e
    errors << e
  end
  errors << response if response and response.code != '200'
  errors
end


def exit_with_code(code, text="")
  puts "#{code} #{text}"
  exit EXIT_STRING_TO_CODE[code]
end

all_errors << check_sockets unless check_sockets.empty?

#if any graphite related sockets are down - immidiate critical.

if all_errors.size != 0
  exit_with_code("CRITICAL",all_errors.to_s)
end

all_errors << check_webfront("/") << check_webfront(render_url)
all_errors.flatten!

if all_errors.size != 0
  exit_with_code("WARN",all_errors.to_s)
end

exit_with_code('OK')
