#!/bin/bash
#
# check_ntp
#
# Checks that an NTP server has a valid response

if [ -z "$1" ]; then
  echo "Usage: $0 ntpserver"
  exit 3
fi

out=$(/usr/sbin/ntpdate -q $1 2>&1)
retcode=$?

if [ "$retcode" -ne 0 ]; then
  echo "CRITICAL - Failed to query NTP server $1"
  echo "Command output: $out"
  exit 2
fi

echo "OK - $out"
exit 0
