#!/bin/bash
now=$(/bin/date +%s)
week=$(expr $now + 604800)
hostname=$(/bin/hostname -f)
HOSTS="host_name;service_display_name;author;comment;duration;end_time"
GET_COLUMNS="GET downtimes\nColumns: host_name service_display_name author comment duration end_time"

while read line; do
#        echo $line
        hostname=$(echo $line | cut -d\; -f1)
        service=$(echo $line | cut -d\; -f2)
        author=$(echo $line | cut -d\; -f3)
        comment=$(echo $line | cut -d\; -f4)
        duration=$(echo $line | cut -d\; -f5)
        end_time=$(echo $line | cut -d\; -f6)
        if [ "$service" = "" ]; then service="HOST DOWNTIME" ; fi
        if [ $end_time -lt $week ]; then
           HOSTS+="\n$hostname;$service;$author;$comment;$duration;$(date -d@$end_time)"
        fi
done < <(echo -e $GET_COLUMNS | /bin/nc $hostname 6557)


if [ $1 ]; then
    echo "<html><body><pre>$(echo -e $HOSTS | /usr/local/bin/csvlook -d\;)</pre></body></html>" | /usr/bin/mail -a "Content-type: text/html" -s "expiring downtimes in next week" $1
else
    echo -e $HOSTS | /usr/local/bin/csvlook -d\;
fi
