# Configures Nagios servers
class twitch_nagios::server (
  $package_version          = $twitch_nagios::server::params::package_version,
  $vhost_name               = $twitch_nagios::server::params::vhost_name,
  $host_config_file         = $twitch_nagios::server::params::host_config_file,
  $service_config_file      = $twitch_nagios::server::params::service_config_file,
  $hostgroup_config_file    = $twitch_nagios::server::params::hostgroup_config_file,
  $servicegroup_config_file = $twitch_nagios::server::params::servicegroup_config_file,
  $config_repo              = $twitch_nagios::server::params::config_repo,
  $config_repo_revision     = $twitch_nagios::server::params::config_repo_revision,
  $livestatus_module        = $twitch_nagios::server::params::livestatus_module,
  $enable_thruk             = $twitch_nagios::server::params::enable_thruk,
  $enable_mrtg              = $twitch_nagios::server::params::enable_mrtg,
  $use_monit                = $twitch_nagios::server::params::use_monit,
  $enable_pnp4nagios        = $twitch_nagios::server::params::enable_pnp4nagios,
  $pnp4nag_rrd_max_age      = $twitch_nagios::server::params::pnp4nag_rrd_max_age,
  $npcd_debug_lev           = $twitch_nagios::server::params::npcd_debug_lev,
  $npcd_log_type            = $twitch_nagios::server::params::npcd_log_type,
  $npcd_max_threads         = $twitch_nagios::server::params::npcd_max_threads,
  $npcd_sleep_time          = $twitch_nagios::server::params::npcd_sleep_time,
  $nrdp_token               = $twitch_nagios::server::params::nrdp_token,
) inherits twitch_nagios::server::params {
  require twitch_core
  anchor { 'twitch_nagios::server::begin': } ->
  class  { 'twitch_nagios::server::dependencies': } ->
  class  { 'twitch_nagios::server::vhost': } ->
  class  { 'twitch_nagios::server::repository': } ->
  class  { 'twitch_nagios::server::collectors': } ->
  class  { 'twitch_nagios::server::configs': } ->
  anchor { 'twitch_nagios::server::end': }

  class  { 'twitch_nagios::server::monitor': }
  if $enable_thruk {
    class  { 'twitch_nagios::server::thruk': }
  }
  if $enable_mrtg {
    class  { 'twitch_nagios::server::mrtg': }
  }
  class  { 'twitch_nagios::server::monit': }
  if $enable_pnp4nagios {
    class  { 'twitch_nagios::server::pnp4nagios': }
  }
  if $nrdp_token == undef {
    class  { 'twitch_nagios::server::nrdp': ensure => 'absent' }
  } else {
    class  { 'twitch_nagios::server::nrdp': }
  }
}
