# Collects Nagios host and service exported resources from PuppetDB, and uses
# them to generate the object configuration files (hosts.cfg, services.cfg,
# etc.)
class twitch_nagios::server::collectors (

    $enable_collectors = true,
){

  if str2bool($enable_collectors) {

    # Collect all exported resources from PuppetDB
    # Based on Naginator / NagiosMaker
    # https://github.com/puppetlabs/puppet/blob/master/lib/puppet/util/nagios_maker.rb
    Nagios_host <<|
      tag == "team_${::twitch_team}_${::twitch_environment}"
    |>> {
      target  => $twitch_nagios::server::host_config_file,
      notify  => Service['nagios'],
    }
    Nagios_service <<|
      tag == "team_${::twitch_team}_${::twitch_environment}"
    |>> {
      target => $twitch_nagios::server::service_config_file,
      notify => Service['nagios'],
    }

    Twitch_nagios::Hostgroup <<|
      tag == "team_${::twitch_team}_${::twitch_environment}"
    |>> {
      target => $twitch_nagios::server::hostgroup_config_file,
      notify => Service['nagios'],
    }

    Twitch_nagios::Servicegroup <<|
      tag == "team_${::twitch_team}_${::twitch_environment}"
    |>> {
      target => $twitch_nagios::server::servicegroup_config_file,
      notify => Service['nagios'],
    }

    # We need to use resource metatypes to make sure that expired resources are
    # actually removed from the host. Otherwise puppet just ignores that they
    # exist and leaves them to whither alone on the filesystem forever
    resources {'nagios_host':
      purge => true,
    }

    resources {'nagios_service':
      purge => true,
    }

    resources {'nagios_hostgroup':
      purge => true,
    }

    resources {'nagios_servicegroup':
      purge => true,
    }
  }
}
