# Install Nagios server dependencies
class twitch_nagios::server::dependencies inherits twitch_nagios::server {
  $manage_apache_service = $twitch_nagios::server::use_monit ? {
      true         => true,
      default      => false,
  }
  class { "php":
    composer => false,
  }
  # The new live status module breaks 4.0.8 configs, so we use the old.
  # If you decide to upgrade away from 4.0.8 you will also get the new
  # livestatus module. The broker module path will have to be changed 
  # in /etc/nagios/nagios.cfg to /usr/lib/mk-livestatus/livestatus.o
  $_livestatus_package = $twitch_nagios::server::package_version ? {
    '4.0.8-2' => 'nagios-livestatus',
    default   => undef,
  }
  $_livestatus_ensure = $twitch_nagios::server::livestatus_module ? {
    true    => 'present',
    default => 'absent',
  }
  class { "apache":
    default_vhost  => false,
    mpm_module     => "prefork",
    service_manage => $manage_apache_service,
  }
  include apache::mod::php
  include apache::mod::prefork

  class { 'twitch_mk_livestatus':
    ensure  => $_livestatus_ensure,
    package => $_livestatus_package,
  }

  # This is our internal packaging of the Nagios source code
  # Created by git-aws.internal.justin.tv/systems/debpkgs
  package { 'nagios4':
    ensure => $twitch_nagios::server::package_version,
  }
  file { '/etc/nagios/static':
    ensure  => 'directory',
    owner   => 'nagios',
    group   => 'nagios',
    mode    => '755',
    require => Package['nagios4'],
  }
  # Put our VCS repo into a ramdisk. This makes startup just a hair faster.
  mount { '/etc/nagios/static':
    ensure  => 'mounted',
    atboot  => true,
    fstype  => 'tmpfs',
    device  => 'tmpfs',
    options => 'defaults,nosuid,size=128m,uid=nagios,gid=nagios',
    require => File['/etc/nagios/static'],
  }
  file { '/var/nagios/cache':
    ensure  => 'directory',
    owner   => 'nagios',
    group   => 'nagios',
    mode    => '755',
    require => Package['nagios4'],
  }
  # Create a ramdisk for status.dat and objects.(pre)cache
  mount { '/var/nagios/cache':
    ensure  => 'mounted',
    atboot  => true,
    fstype  => 'tmpfs',
    device  => 'tmpfs',
    options => 'defaults,noexec,nosuid,size=2000m,uid=nagios,gid=nagios',
    require => File['/var/nagios/cache'],
  }

  # This is only here to set setgid on the folder.
  # It'll only work on second run after the mount.
  file { '/var/nagios/spool/checkresults':
    ensure  => 'directory',
    owner   => 'nagios',
    group   => 'nagcmd',
    mode    => '2775',
    require => Package['nagios4'],
  }
  # Create a ramdisk for NRDP (passive) checks.
  # This folder is created by Nagios package.
  mount { '/var/nagios/spool/checkresults':
    ensure  => 'mounted',
    atboot  => true,
    fstype  => 'tmpfs',
    device  => 'tmpfs',
    options => 'defaults,noexec,nosuid,size=128m,uid=nagios,gid=nagcmd',
    require => Package['nagios4'],
  }

  file { '/etc/nagios/cgi.cfg':
    ensure  => 'link',
    target  => '/etc/nagios/static/cgi.cfg',
    owner   => 'nagios',
    group   => 'nagios',
    require => Package['nagios4'],
  }
  file { '/etc/nagios/nagios.cfg':
    ensure  => 'link',
    target  => '/etc/nagios/static/nagios.cfg',
    owner   => 'nagios',
    group   => 'nagios',
    require => Package['nagios4'],
  }
  file { '/etc/default/nagios':
    ensure  => 'present',
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => "unset http_proxy https_proxy HTTPS_PROXY HTTP_PROXY\n",
    require => Package['nagios4'],
  }
  file { [ '/etc/nagios/resource.cfg', '/etc/nagios/nrpe_local.cfg' ]:
    ensure  => 'absent',
    require => Package['nagios4'],
  }

  package { "nagios-plugins-basic":
    ensure => installed,
  }

  package { "nagios-plugins-standard":
    ensure => installed,
  }

  package {'nagios-nrpe-plugin':
    ensure          => 'installed',
    install_options => ['--no-install-recommends'],
  }

  # Pager duty installation

  file{ '/usr/local/bin/pagerduty_nagios.pl':
    ensure  => present,
    mode    => '0755',
    source  => "puppet:///modules/${module_name}/server/pagerduty_nagios.pl",
    require => Package['libhttp-request-ascgi-perl'],
  }
  cron { 'pagerduty_nagios_flush':
    command  => '/usr/local/bin/pagerduty_nagios.pl flush',
    user     => nagios,
    hour     => '*',
    minute   => '*',
    month    => '*',
    monthday => '*',
    weekday  => '*',
    require  => File['/usr/local/bin/pagerduty_nagios.pl'],
  }

  package {'libhttp-request-ascgi-perl':
    ensure => 'installed',
  }

  package {'python-psycopg2':
    ensure => 'installed',
  }

  # Configure NSCA daemon.
  package { 'nsca':
    ensure => 'latest',
  }
  file { '/etc/nsca.cfg':
    ensure  => 'present',
    owner   => 'root',
    group   => 'root',
    mode    => '644',
    source  => "puppet:///modules/${module_name}/server/nsca.cfg",
    require => Package['nsca'],
    notify  => Service['nsca'],
  }

  # Used by common checks
  package {['consul-alerts', 'libnagios-plugin-perl', 'libcache-memcached-perl', 'libjson-perl', 'liblwp-useragent-determined-perl', 'postgresql-client', 'envoy-check']:
    ensure => 'latest',
  }

  include twitch_python::pip::pynagios

  package {'nagiosplugin':
    ensure   => 'installed',
    provider => 'pip',
  }

  package {'numpy':
    ensure   => 'installed',
    provider => 'pip',
  }

  # pandas needs gcc to install
  include gcc
  package {'pandas':
    ensure   => 'installed',
    provider => 'pip',
    require  => Package['gcc']
  }
}
