# Adds monit watchers to your nagios daemons.
# Enable this module in hiera, with:
# twitch_nagios::server::use_monit: true

class twitch_nagios::server::monit inherits twitch_nagios::server {
  # Set these based on what's turned on or off in our plugin pool.
  if $twitch_nagios::server::use_monit == true {
    $nagios_service_ensure = 'present'
    $npcd_service_ensure = $twitch_nagios::server::enable_pnp4nagios ? {
        true         => 'present',
        default      => 'absent',
    }
  } else {
    $nagios_service_ensure = 'absent'
    $npcd_service_ensure = 'absent'
  }

  # Monitor our server with monit.
  twitch_monit::check { 'nagios':
    ensure         => $nagios_service_ensure,
    pidfile        => '/var/nagios/nagios.lock',
    # This is in seconds, not cycles. :(
    check_interval => 10,
    start_program  => '/usr/sbin/service nagios start',
    stop_program   => '/usr/sbin/service nagios stop',
    # cycles are 5 seconds.
    custom_checks => [ 'if does not exist for 6 cycles then restart' ],
    cwd            => '/',
    uid            => 'root',
    require        => Service['nagios'],
  }
  # Monitor our web server with monit too.
  twitch_monit::check { 'apache2':
    ensure         => $nagios_service_ensure,
    pidfile        => '/var/run/apache2.pid',
    check_interval => 30,
    start_program  => '/usr/sbin/service apache2 start',
    stop_program   => '/usr/sbin/service apache2 stop',
    custom_checks => [ 'if does not exist for 18 cycles then restart' ],
    cwd            => '/',
    uid            => 'root',
    require        => Class['apache::service'],
  }
  # Monitor npcd with monit. You must enable this in hiera.
  twitch_monit::check { 'npcd':
    ensure         => $npcd_service_ensure,
    pidfile        => '/var/run/npcd.pid',
    check_interval => 15,
    start_program  => '/usr/sbin/service npcd start',
    stop_program   => '/usr/sbin/service npcd stop',
    custom_checks => [ 'if does not exist for 9 cycles then restart' ],
    cwd            => '/',
    uid            => 'root',
  }
}
