# Module that setup nagios server monitoring
class twitch_nagios::server::monitor inherits twitch_nagios::server {

  twitch_nagios::service {'nagios_service':
    is_nrpe     => true,
    command     => 'check_nagios -e 5 -F /var/nagios/status.dat -C nagios.cfg',
    description => 'Nagios Service Running',
    use         => 'generic-systems-service',
  }

  twitch_nagios::service {'nagios_config_syntax':
    is_nrpe     => true,
    command     => '/opt/nagios_checks/check_nagios_syntax.sh',
    description => 'Nagios Config Syntax',
    use         => 'generic-systems-service',
  }

  file {'/opt/nagios_checks/check_nagios_syntax.sh':
    ensure => 'present',
    owner  => 'root',
    group  => 'nagios',
    mode   => '0750',
    source => 'puppet:///modules/twitch_nagios/server/common_checks/check_nagios_syntax.sh',
  }
}
