# This installs MRTG and a config to graph nagiostats.
#

class twitch_nagios::server::mrtg inherits twitch_nagios::server {
  # This variable is used in our apache template.
  $ldap_server = hiera('ldap_server')

  package { 'mrtg':
    ensure  => 'latest',
  }

  file {'/etc/mrtg.cfg':
    ensure  => 'present',
    source  => 'puppet:///modules/twitch_nagios/server/mrtg.cfg',
    mode    => '0600',
    owner   => 'root',
    group   => 'root',
    require => Package['mrtg'],
    notify  => Exec['mrtg-createindex'],
  }

  file {'/var/www/mrtg':
    ensure  => 'directory',
    mode    => '0644',
    owner   => 'root',
    group   => 'root',
    require => Package['mrtg'],
  }

  exec { 'mrtg-createindex':
    command => '/usr/bin/indexmaker --output=/var/www/mrtg/index.html /etc/mrtg.cfg --title=Nagios',
    creates => '/var/www/mrtg/index.html',
    require => File['/etc/mrtg.cfg','/var/www/mrtg'],
  }

  # This will overwrite the cron created by the package.
  file { '/etc/cron.d/mrtg': ensure => 'absent' }
  cron { 'mrtg':
    ensure  => 'present',
    user    => 'root',
    command => 'env LANG=C /usr/bin/mrtg /etc/mrtg.cfg 2>&1 | logger -p local3.info -t mrtg',
    require => File['/etc/mrtg.cfg'],
  }

  apache::custom_config { 'mrtg':
    ensure  => 'present',
    content => template('twitch_nagios/server/mrtg-apache.conf.erb'),
  }
}
