# Install NRDP. To make this work, simply set a token in hiera:
# twitch_nagios::server::nrdp_token: some_long_random_string_here

class twitch_nagios::server::nrdp (
  $ensure = 'present',
) inherits twitch_nagios::server {
  $dir_ensure = $ensure ? {
    'present' => 'directory',
    default   => 'absent',
  }

  file { ['/usr/local/nrdp', '/usr/local/nrdp/server' ]:
    ensure  => $dir_ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '644',
    force   => true,
    require => Package['nagios4'],
  }

  if $dir_ensure != 'absent' {
    file { '/usr/local/nrdp/README.txt':
      ensure  => 'present',
      owner   => 'nagios',
      group   => 'nagios',
      content => "Do not store anything here. Puppet may delete this directory.\n",
      require => File['/usr/local/nrdp/server'],
      before  => Apache::Custom_config['nrdp'],
    } ->
    file { '/usr/local/nrdp/server/index.php':
      ensure  => 'present',
      owner   => 'nagios',
      group   => 'nagios',
      source  => "puppet:///modules/${module_name}/server/nrdp/index.php",
    } ->
    # This is a template so we can control the token with hiera.
    file { '/usr/local/nrdp/server/config.inc.php':
      ensure  => 'present',
      owner   => 'nagios',
      group   => 'nagios',
      content => template("${module_name}/server/nrdp/config.inc.php.erb"),
    } ->
    file { '/usr/local/nrdp/server/includes':
      ensure  => 'present',
      recurse => true,
      replace => true,
      owner   => 'nagios',
      group   => 'nagios',
      source  => "puppet:///modules/${module_name}/server/nrdp/includes",
    } ->
    file { '/usr/local/nrdp/server/plugins':
      ensure  => 'present',
      recurse => true,
      replace => true,
      owner   => 'nagios',
      group   => 'nagios',
      source  => "puppet:///modules/${module_name}/server/nrdp/plugins",
    }
  }

  apache::custom_config { 'nrdp':
    ensure  => $ensure,
    content => template("${module_name}/server/nrdp/apache.conf.erb"),
  }
}
