# This installs pnp4nagios. Changes to your VCS repo are still
# required to fully integrate this in your nagios configuration.

class twitch_nagios::server::pnp4nagios inherits twitch_nagios::server {
  # These are all used in our templates.
  $ldap_server         = hiera('ldap_server')
  $npcd_log_type       = $twitch_nagios::server::npcd_log_type
  $npcd_debug_lev      = $twitch_nagios::server::npcd_debug_lev
  $npcd_sleep_time     = $twitch_nagios::server::npcd_sleep_time
  $npcd_max_threads    = $twitch_nagios::server::npcd_max_threads
  $pnp4nag_rrd_max_age = $twitch_nagios::server::pnp4nag_rrd_max_age

  package { 'pnp4nagios': ensure  => '0.6.25-1' }

  npcdconfigfiles { ['npcd.cfg', 'config.php', 'rra.cfg', 'process_perfdata.cfg', 'nagios.cfg', 'nagios_objects.cfg']: }
  define npcdconfigfiles() {
    file { "/etc/pnp4nagios/$name":
      ensure  => present,
      content => template("twitch_nagios/server/pnp4nagios/$name.erb"),
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      notify  => Service['npcd'],
      require => Package['pnp4nagios'],
    }
  }

  file { '/usr/share/pnp4nagios/html/install.php':
    ensure => 'absent',
    require => Package['pnp4nagios'],
  }

  file { '/etc/default/npcd':
    ensure  => 'absent',
    require => Package['pnp4nagios'],
  }

  # Directories created by the package that must exist.
  $npcd_directories = [ '/var/log/pnp4nagios', '/var/log/pnp4nagios/kohana', '/var/log/pnp4nagios/stats', '/var/lib/pnp4nagios', '/var/spool/pnp4nagios/npcd', '/var/spool/pnp4nagios' ]
  file { $npcd_directories:
    ensure  => 'directory',
    mode    => '0755',
    owner   => 'nagios',
    group   => 'nagios',
    require => Package['pnp4nagios','nagios4'],
  }
  mount { '/var/spool/pnp4nagios':
    ensure  => 'mounted',
    atboot  => true,
    fstype  => 'tmpfs',
    device  => 'tmpfs',
    options => 'defaults,noexec,nosuid,size=128m,uid=nagios,gid=nagios',
    require => File['/var/spool/pnp4nagios'],
    before  => File['/var/spool/pnp4nagios/npcd'],
  }

  service { 'npcd':
    ensure     => 'running',
    enable     => true,
    hasstatus  => true,
    hasrestart => true,
    require    => File['/etc/pnp4nagios/npcd.cfg'],
  }

  apache::custom_config { 'pnp4nagios':
    ensure  => 'present',
    content => template('twitch_nagios/server/pnp4nagios/pnp4nagios-apache.conf.erb'),
  }
}
