# Checks out the latest version of the static Nagios configuration from Git
class twitch_nagios::server::repository (
  $nagios_user   = 'nagios',
  $nagios_group   = 'nagios',
) {
  if $twitch_nagios::server::config_repo {
    $git_server = hiera('twitch_git_server')
    $repo_url = "${git_server}:${::twitch_nagios::server::config_repo}"
    $secret_name = "${::twitch_team}/${::twitch_team}-nagios/production/nagios-git-ssh-private-key"

    file { '/var/lib/nagios/.ssh':
      ensure  => 'directory',
      owner   => $nagios_user,
      group   => $nagios_group,
      mode    => '0700',
    }

    twitch_sandstorm_agent::template { 'nagios-git-ssh-private-key':
      destination     => '/var/lib/nagios/.ssh/id_rsa',
      group           => $nagios_group,
      owner           => $nagios_user,
      mode            => '0600',
      contents        => "{{ key \"${secret_name}\" }}\n",
      restart_command => '',
    }

    vcsrepo {'/etc/nagios/static':
      ensure   => 'latest',
      revision => $twitch_nagios::server::config_repo_revision,
      provider => 'git',
      source   => "git@${repo_url}.git",
      user     => $nagios_user,
      notify   => Service['nagios'],
      require  => Twitch_sandstorm_agent::Template['nagios-git-ssh-private-key'],
    }
  }
}
