# This installs Thruk along side Nagios.
# Find it at http://yourteam-nagios.internal.justin.tv/thruk
# 
class twitch_nagios::server::thruk inherits twitch_nagios::server {
  # This variable is used in our apache template.
  $ldap_server = hiera('ldap_server')
  $_pnp4nagios_enabled = $twitch_nagios::server::enable_pnp4nagios ? {
      true    => 'link',
      default => 'absent',
  }
  apt::source { 'consol_labs':
    location => 'http://labs.consol.de/repo/stable/ubuntu',
    repos    => 'main',
    key      => 'F2F97737B59ACCC92C23F8C7F8C1CA08A57B9ED7',
  }
  package { 'thruk':
    ensure  => 'latest',
    require => Apt::Source['consol_labs'],
  }
  file {'/etc/thruk/cgi.cfg':
    ensure  => 'present',
    source  => 'puppet:///modules/twitch_nagios/server/thruk-cgi.cfg',
    mode    => '0644',
    owner   => 'root',
    group   => 'root',
    notify  => Class['apache::service'],
    require => Package['thruk'],
  }
  # This file contains the local server.
  file {'/etc/thruk/thruk_local.d/thruk_backend.conf':
    ensure  => 'present',
    source  => 'puppet:///modules/twitch_nagios/server/thruk_backend.conf',
    mode    => '0644',
    owner   => 'root',
    group   => 'root',
    notify  => Class['apache::service'],
    require => Package['thruk'],
  }
  # Add this link if we also have pnp4nagios running.
  # This is a relative-path link to a file in the same directory.
  file { '/etc/thruk/ssi/status-header.ssi':
    ensure  => $_pnp4nagios_enabled,
    target  => 'status-header.ssi.example',
    notify  => Class['apache::service'],
    require => Package['thruk'],
  }
  # This is used by Thruk.
  class { 'apache::mod::fcgid':
    options => {
      'AddHandler'   => 'fcgid-script .sh',
    }
  }
  apache::custom_config { 'thruk':
    ensure  => present,
    content => template("${module_name}/server/thruk-apache.conf.erb"),
  }
}
