# Configures Nagios vhost
class twitch_nagios::server::vhost inherits twitch_nagios::server {
  $vhost_name = $twitch_nagios::server::vhost_name
  $ldap_config = {
    auth_require => 'valid-user',
    auth_basic_provider => 'ldap',
    auth_type => 'basic',
    auth_name => "Nagios [LDAP]",
    custom_fragment => "AuthLDAPURL ldaps://${::twitch_core::authentication::ldap::ldap_server}/ou=Users,dc=justin,dc=tv",
  }
  $_pnp4nagios_enabled = $twitch_nagios::server::enable_pnp4nagios ? {
      true    => 'present',
      default => 'absent',
  }

  $cert_file         = '/etc/ssl/certs/wildcard.internal.justin.tv.pem'
  $key_file          = '/etc/ssl/private/wildcard.internal.justin.tv.key'
  $wildcard_jtv_cert = 'syseng/ssl_certs/production/wildcard.internal.justin.tv.cert'
  $wildcard_jtv_key  = 'syseng/ssl_keys/production/wildcard.internal.justin.tv.key'
  $redirect_dest     = $twitch_nagios::server::enable_thruk ? {
            true     => '/thruk/',
            default  => '/nagios',
  }
  twitch_sandstorm_agent::template { 'wildcard-jtv-cert':
    destination     => $cert_file,
    key             => $wildcard_jtv_cert,
    restart_command => 'service apache2 restart',
  }

  twitch_sandstorm_agent::template { 'wildcard-jtv-key':
    destination     => $key_file,
    key             => $wildcard_jtv_key,
    restart_command => 'service apache2 restart',
  }

  file { '/usr/share/nagios/web/ssi/status-header.ssi':
    ensure  => $_pnp4nagios_enabled,
    source  => 'puppet:///modules/twitch_nagios/server/nagios-status-header.ssi',
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    require => Package['nagios4'],
    notify  => Class['apache::service'],
  }

  apache::vhost { 'nagios-redir':
    servername      => $vhost_name,
    port            => 80,
    docroot         => '/var/www/redirect',
    redirect_status => 'permanent',
    redirect_dest   => "https://${vhost_name}/",
  }

  apache::vhost { 'nagios':
    servername  => $vhost_name,
    port        => '443',
    docroot     => '/var/www',
    ssl         => true,
    ssl_cert    => $cert_file,
    ssl_chain   => $cert_file,
    ssl_key     => $key_file,

    redirectmatch_status => '301',
    redirectmatch_regexp => '^/$',
    redirectmatch_dest   => $redirect_dest,
    aliases              => [
      {
        scriptalias => '/nagios/cgi-bin',
        path        => '/usr/share/nagios/cgi',
      },
      {
        alias => '/nagios',
        path  => '/usr/share/nagios/web',
      },
      {
        alias => '/images',
        path  => '/usr/share/nagios/web/images',
      },
      {
        alias => '/js',
        path  => '/usr/share/nagios/web/js',
      },
      {
        alias => '/stylesheets',
        path  => '/usr/share/nagios/web/stylesheets',
      },
    ],
    directories => [
      merge({
        path           => '/usr/share/nagios/web',
        options        => ['None'],
        allow_override => ['None'],
        order          => 'allow,deny',
        allow          => 'from all',
      }, $ldap_config),
      merge({
        path           => '/usr/share/nagios/cgi',
        allow_override => 'None',
        order          => 'allow,deny',
        allow          => 'from all',
      }, $ldap_config),
    ],
  }

  class {'apache::mod::authnz_ldap':
    verifyServerCert => false,
  }
}
