#this is for the video-nagios override found in heira/twitch_role/production
class twitch_nagios::server::video_specifics inherits twitch_nagios::server {
  require twitch_python::pip::csvkit
  require twitch_python::pip::jira 
  $vhost_name = $twitch_nagios::server::vhost_name
  $nrdp_token = $twitch_nagios::server::nrdp_token
  $key_prefix   = 'video-ops/video-nagios/production/jira'
  $token_prefix = 'video-ops/video-nagios/production/twitch_client_id'

  # Most of the things in this file only go on prod, not staging.
  $_ensure_production = $::twitch_environment ? {
    'production' => 'present',
    default      => 'absent',
  }

  twitch_sandstorm_agent::template { 'auth_jira':
    ensure      => $_ensure_production,
    destination => '/etc/nagios/static/eventhandlers/jira.auth',
    mode        => '0600',
    owner       => 'nagios',
    group       => 'nagios',
    key         => $key_prefix,
    require     => Vcsrepo['/etc/nagios/static'],
  }

  twitch_sandstorm_agent::template { 'twitch_networkdb_secret':
    ensure      => 'present',
    destination => '/etc/nagios/networkdb.secret',
    mode        => '0600',
    owner       => 'nagios',
    group       => 'nagios',
    key         => 'video-ops/video-nagios/production/twitch_networkdb_secret',
    require     => Vcsrepo['/etc/nagios/static'],
  }

  twitch_sandstorm_agent::template { 'client_id_token':
    ensure      => $_ensure_production,
    destination => '/etc/nagios/static/client_id.token',
    mode        => '0600',
    owner       => 'nagios',
    group       => 'nagios',
    key         => $token_prefix,
    require     => Vcsrepo['/etc/nagios/static'],
  }

  file { '/var/lib/nagios/check_usher_health.py':
    ensure  => 'present',
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    content => template('twitch_nagios/server/check_usher_health.py.erb'),
  }

  file { '/var/lib/nagios/expiring_downtimes.sh':
    ensure  => $_ensure_production,
    owner   => 'nagios',
    group   => 'nagios',
    mode    => '0755',
    source  => "puppet:///modules/${module_name}/server/expiring_downtimes.sh",
  }

  cron { 'check_usher_health':
    command => '/var/lib/nagios/check_usher_health.py  2>&1 | logger -p local3.info -t check_usher_health',
    user    => 'nagios',
    minute  => '*/5',
    require => File['/var/lib/nagios/check_usher_health.py'],
  }

  cron { 'expiring_downtimes':
    ensure  =>  $_ensure_production,
    command => '/var/lib/nagios/expiring_downtimes.sh dknight@justin.tv,kevipear@justin.tv,newhalld@justin.tv,kurjanon@twitch.tv,ghalim@justin.tv,echaveza@justin.tv 2>&1 | logger -p local3.info -t nagios-expiring-downtimes',
    user    => 'nagios',
    weekday => '1',
    minute  => '0',
    hour    => '8',
    require => File['/var/lib/nagios/expiring_downtimes.sh'],
  }

  $cron_cmd  = '/usr/bin/find /var/nagios/archives -maxdepth 1 -type f -mtime +90 -delete'
  cron { 'nagios_archive_clean':
    command => $cron_cmd,
    user    => root,
    hour    => 0,
    minute  => 5,
  }

  file { '/var/lib/nagios/downtime_jira_checker.py':
    ensure  => $_ensure_production,
    owner   => 'nagios',
    group   => 'nagios',
    mode    => '0755',
    source  => "puppet:///modules/${module_name}/server/downtime_jira_checker.py",
  }
  cron { 'downtime_jira_checker':
    ensure  => $_ensure_production,
    command => '/usr/bin/python /var/lib/nagios/downtime_jira_checker.py 2>&1 | logger -p local3.info -t jira_downtime',
    user    => 'nagios',
    minute  => '0',
    hour    => '1',
    require => File['/var/lib/nagios/downtime_jira_checker.py'],
  }

}

