# Essentially a wrapper for the nagios_servicegroup resource, but allows services
# to export their own servicegroups while avoiding duplicate resources
#
# Usage:
#
# @@twitch_nagios::servicegroup {"groupname#${::fqdn}":
#   alias => "human readable groupname",
#   export => true,
# }
#
# The actual name of the servicegroup goes before the # in the resource name. The
# portion after the # will be discarded, and is only used to avoid puppet
# complaining about duplicated exported resources.
#
# Collection:
#
# Twitch_nagios::Servicegroup <<||>> {
#   notify => Service['nagios'],
# }

define twitch_nagios::servicegroup (
  $export    = false,
  $ensure    = 'present',
  $nagios_alias = undef,
  $target    = undef,
  $action_url= undef,
  $notes     = undef,
  $notes_url = undef,
  $register  = undef,
  $use       = undef,
) {
  if $export {
    # Split the resource name on #
    $realname = inline_template("<%= name.rindex('#').nil?? name : name.slice(0, name.rindex('#')) %>")
    # If we need the unique portion after the # in the future, here's how to grab it.
    # $uid = inline_template("<%= name.rindex('#').nil?? '' : name.slice(name.rindex('#')+'#'.length, name.length-name.rindex('#')-'#'.length) %>")

    ensure_resource('twitch_nagios::servicegroup', $realname, delete_undef_values({
      ensure       => $ensure,
      nagios_alias => $nagios_alias,
      target       => $target,
      action_url   => $action_url,
      notes        => $notes,
      notes_url    => $notes_url,
      use          => $use,
    }))
  } else {
    $servicegroup = { "${name}" => delete_undef_values({
      ensure     => $ensure,
      alias      => $nagios_alias,
      target     => $target,
      action_url => $action_url,
      notes      => $notes,
      notes_url  => $notes_url,
      use        => $use,
    })}
    create_resources(nagios_servicegroup, $servicegroup)
  }
}
