# Configures DHCP and DNS for systems which run inside the Twitch network
# Applies to: bare metal, KVM instances, Vagrant instances
# Does not appy to: EC2 instances, Docker containers

# This class depends on one custom Facter fact:
#   - dhcp.rb
# You can find it in twitch_networking/lib/facter/

# This class depends on one custom Puppet provider library:
#   - dns_lookup.rb
# You can find it in twitch_networking/lib/puppet/parser/functions/
class twitch_networking::dns_and_dhcp (
  $dns_servers   = ['10.254.0.3', '10.254.0.8'],
  $search_domain = "justin.tv",
  $use_dhcp      = true
) {
  validate_array($dns_servers)
  validate_string($search_domain)
  validate_bool($use_dhcp)

  # Rotate the list of DNS servers (based on FQDN hash)
  $rotated_dns_servers = fqdn_rotate($dns_servers)

  # This package conflicts with our DHCP configuration
  package { 'resolvconf':
    ensure => 'absent'
  }

  # Template out resolv.conf for non-DHCP systems
  if ($use_dhcp != true) {
    file { "/etc/resolv.conf":
      owner   => "root",
      group   => "root",
      mode    => "0644",
      content => template("${module_name}/resolv.conf.erb"),
    }
  }
}
