# Configures HTTP proxy for nodes without Internet access
#
# This class depends on one custom fact
#   - ipaddress_primary.rb
# You can find it in modules/twitch_networking/lib/facter/
#
# WARNING: This class is part of the "no_internet_access" stage, which runs
#          before any resource in the "main" stage. This means this class
#          should only contain resources built from primitives (e.g. `file`),
#          and no external modules or namespaces!
class twitch_networking::http_proxy (
  $proxy_ensure      = $twitch_networking::params::twitch_proxy_ensure,
  $twitch_http_proxy = 'http://proxy.internal.justin.tv:9797/',
  $twitch_no_proxy   = $twitch_networking::params::twitch_no_proxy,
  $twitch_apt_proxy  = 'http://proxy.internal.justin.tv:9797/'
) inherits twitch_networking {
  validate_string($proxy_ensure, $twitch_http_proxy, $twitch_apt_proxy)
  validate_array($twitch_no_proxy)

  # Variables used: $twitch_http_proxy, $twitch_no_proxy
  file { "/etc/profile.d/proxy.sh":
    ensure  => $proxy_ensure,
    owner   => "root",
    group   => "root",
    mode    => "0755",
    content => template("${module_name}/proxy.sh.erb"),
  }

  if $::osfamily == 'Debian' {
    # Variables used: $twitch_apt_proxy
    file { '/etc/apt/apt.conf.d/95proxy':
      ensure  => $proxy_ensure,
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      content => template("${module_name}/apt_proxy.conf.erb"),
    }
  } elsif $::osfamily == 'RedHat' {
    # Our yum.conf file isn't managed by puppet (yet), so just use augeas.
    augeas { 'yum_proxy':
      context => '/files/etc/yum.conf',
      changes => [
        "set main/proxy ${twitch_http_proxy}"
      ]
    }
  }
}
