# Configures things necessary for nodes inside the Twitch network
class twitch_networking inherits twitch_networking::params {
  # Configure resolv.conf and things like that
  include twitch_networking::dns_and_dhcp

  # Define a new stage which runs before the "main" stage
  stage { "no_internet_access":
    before => Stage["main"],
  }

  # Configure the HTTP proxy for systems without Internet access, using the
  # stage defined above
  class { "twitch_networking::http_proxy":
    stage => "no_internet_access",
  }
}
