class twitch_networking::params {
  # Defines a list of networks which should NOT use the HTTP proxy
  $twitch_no_proxy     = [
    'localhost',
    '127.0.0.1',
    '127.0.1.1',
    '127.0.0.0/8',
    '199.9.248.0/21',
    '192.16.64.0/21',
    '10.0.0.0/8',
    '.internal.justin.tv',
    '.internal.twitch.tv',
    '.justin.tv',
    '.twitch.tv',
    '.jtvnw.net'
  ]

  # Determines whether or not the proxy file should be installed
  if $ec2_instance_id != "" {
    $twitch_proxy_ensure = 'absent'
  } else {
    $twitch_proxy_ensure = $::ipaddress_primary ? {
      /^10\./ => 'present',
      default => 'absent',
    }
  }
}
