class twitch_nginx::install inherits twitch_nginx {

  class { 'nginx':
    manage_repo => false,
  }

  # Make sure that the twitch repo is set in place
  # so that nginx can actally be installed
  Exec['apt_update'] -> Class['nginx']

  if $::lsbdistcodename == "xenial" {
    file { '/lib/systemd/system/nginx.service':
      ensure  => file,
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      content => template("${module_name}/nginx.service.erb"),
    }
  } else {
    file { '/etc/init.d/nginx':
      ensure  => present,
      content => template("${module_name}/nginx.init.erb"),
      owner   => 'root',
      group   => 'root',
      mode    => 0755,
    }
  }

  file { "/usr/local/nginx/conf/nginx.conf":
    ensure  => present,
    content => template("${module_name}/nginx.conf.erb"),
    notify  => Service['nginx'],
  }

  file { "${nginx_conf_dir}/mime.types":
    ensure  => present,
    content => template("${module_name}/mime.types.erb"),
    notify  => Service['nginx'],
  }

  file { "${nginx_conf_dir}/log_format.conf":
    ensure  => present,
    content => template("${module_name}/log_format.conf.erb"),
    notify  => Service['nginx'],
  }

  file { '/etc/default/nginx':
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => "ulimit -n ${nginx_ulimit}",
    notify  => Service['nginx'],
  }

}
