class twitch_nginx::logrotate (
  $nginx_logrotate_path = $twitch_nginx::params::nginx_logrotate_path,
  $nginx_pidfile        = $twitch_nginx::params::nginx_pidfile,
) inherits twitch_nginx::params {

  logrotate::rule { 'nginx':
    ensure          => present,
    path            => $nginx_logrotate_path,
    missingok       => true,
    rotate_every    => 'day',
    sharedscripts   => true,
    compress        => true,
    delaycompress   => true,
    create          => true,
    create_mode     => '0644',
    create_owner    => 'nobody',
    ifempty         => false,
    postrotate      => "test ! -f ${nginx_pidfile} || kill -USR1 `cat ${nginx_pidfile}`",

  }
}
