class twitch_nginx::params {

  $worker_processes = 8

  $nginx_dir             = "/usr/local/nginx"
  $nginx_conf_dir        = "${nginx_dir}/conf"

  $nginx_log_dir         = '/var/log/nginx'
  $nginx_error_log       = "${nginx_log_dir}/error.log"
  $nginx_access_log      = "${nginx_log_dir}/access.log"
  $nginx_access_log_type = 'combined'

  #$nginx_vhost_dir       = "${nginx_conf_dir}/servers"
  $nginx_vhost_dir       = "/etc/nginx/sites-enabled"

  $nginx_pidfile         = '/var/run/nginx.pid'

  $nginx_ulimit          = '262144'

  $worker_connections    = 65536

  $sendfile              = 'on'

  $keepalive_timeout     = 0

  $ssl_session_timeout   = '10m'
  $ssl_session_cache     = 'shared:SSL:10m'

  $server_tokens         = 'off'

  $has_nginx_size        = false
  $server_name_hash_size = 64

  $has_gzip              = false

  $has_twitch_scheme     = false

  $has_ldap              = false
  $allowed_ldap_groups   = false

  $l3_proto_var          = "http_x_clientprotocol"

  $nginx_logrotate_path  = ['/var/log/nginx_*.log',"${nginx_log_dir}/*.log"]

}
