# Sets up filebeat prospectors to ship puppetmaster logs to centralized logging
class twitch_puppet_master::logging (
  $log_output_tag = $twitch_core::logging::filebeat::output_tag,
) {
  ::filebeat::prospector { 'puppet_master_access':
    paths    => [
      "/var/log/apache2/puppet-${::fqdn}_access_ssl.log",
    ],
    doc_type => 'puppet_master_access',
    fields   => {
      'output' => $log_output_tag,
    }
  }

  ::filebeat::prospector { 'puppet_master_error':
    paths    => [
      "/var/log/apache2/puppet-${::fqdn}_error_ssl.log",
    ],
    doc_type => 'puppet_master_error',
    fields   => {
      'output' => $log_output_tag,
    }
  }
}
