class twitch_puppet_master::webhook_receiver(
  $user                  = 'puppet',
  $group                 = 'puppet',
  $github_webhook_port   = '8000',
  $github_webhook_dir    = '/opt/github-webhook-receiver',
  $github_webhook_script = 'github-webhook-receiver.py',
  $github_webhook_pidfile= '/var/run/github-webhook-receiver.pid',
  $git_project           = 'systems/puppet-ci',
  $git_server            = hiera('twitch_git_server'),
  $puppet_confdir        = '/etc/puppet',
  $puppet_envdir         = '/etc/puppet/environments',
  $puppet_vardir         = '/var/lib/puppet',
) {
  validate_string($git_project)
  validate_string($git_server)

  file { $github_webhook_dir:
    ensure => 'directory',
    owner  => $user,
    group  => $group,
    mode   => '0755'
  }

  file { "${github_webhook_dir}/${github_webhook_script}":
    ensure  => 'present',
    owner   => $user,
    group   => $group,
    mode    => '0755',
    content => template("${module_name}/${github_webhook_script}.erb"),
    require => File[$github_webhook_dir],
    notify  => Twitch_monit::Check['github-webhook-receiver'],
  }

  file { $github_webhook_pidfile:
    ensure => 'present',
    owner  => $user,
    group  => $group,
    mode   => '0644'
  }

  file { "${puppet_vardir}/.ssh":
    ensure => 'directory',
    owner  => $user,
    group  => $group,
    mode   => '0700',
  }

  # This key is for checking out the repo from git when an update is received

  # TODO: Add user/group/mode to these two templates, right now the perms will
  # need to be fixed manually. Commented out for now.
  $puppet_keyfile = "${puppet_vardir}/.ssh/id_rsa"

  twitch_sandstorm_agent::template { 'webhook-ssh-key-priv':
    destination => $puppet_keyfile,
    key         => 'syseng/puppet/production/webhook_ssh_key_priv',
    require     => File["${puppet_vardir}/.ssh"],
    # mode        => '0600',
    # owner       => $user,
    # group       => $group,
  }

  # This is a public key, but I put it in sandstorm so that the pair is stored
  # in the same place instead of having to search.
  twitch_sandstorm_agent::template { 'webhook-ssh-key-pub':
    destination => "${puppet_keyfile}.pub",
    key         => 'syseng/puppet/production/webhook_ssh_key_pub',
    require     => File["${puppet_vardir}/.ssh"],
    # mode        => '0644',
    # owner       => $user,
    # group       => $group,
  }

  twitch_monit::check { 'github-webhook-receiver':
    pidfile        => $github_webhook_pidfile,
    cwd            => $github_webhook_dir,
    uid            => $user,
    gid            => $group,
    check_interval => 5,
    command        => "python ${github_webhook_script}",
    require        => [
                        File["${github_webhook_dir}/${github_webhook_script}"],
                        File[$github_webhook_pidfile]
                      ],
    subscribe      => Class['twitch_puppet_master'],
  }
}
