class twitch_puppetboard {
  # dependencies
  include "apache"
  include "apache::mod::wsgi"

  # app server
  class { "::puppetboard":
    groups               => "puppet",
    puppetdb_host        => "puppetdb-2a748adc.prod.us-west2.justin.tv",
    puppetdb_port        => "8081",
    # Use the CA cert instead of "True" here since the Puppet CA is not in the
    # CA file for the OS
    puppetdb_ssl_verify  => "/var/lib/puppet/ssl/certs/ca.pem",
    puppetdb_key         => "/var/lib/puppet/ssl/private_keys/${::fqdn}.pem",
    puppetdb_cert        => "/var/lib/puppet/ssl/certs/${::fqdn}.pem",
  }

  # frontend
  class { "::puppetboard::apache::vhost":
    vhost_name => "puppetboard.prod.us-west2.justin.tv",
    port       => "80",
  }
}
