# Installs and configures PuppetDB
class twitch_puppetdb {
  require twitch_core

  file { "/opt/twitch/puppetdb":
    ensure => directory,
    owner  => "root",
    group  => "root",
    mode   => "0755",
  }

  class { "puppetdb":
    database_name      => "puppetdb",
    disable_ssl        => false,
    java_args          => {
      "-Xmx" => "3072m"  # 128 + node count, rounded up
    },
    listen_address     => "0.0.0.0",
    node_purge_ttl     => "7d",  # additive with node_ttl, effectively 14d
    node_ttl           => "7d",
    report_ttl         => "14d",
    ssl_ca_cert        => "/etc/puppetdb/ssl/ca.pem",
    ssl_cert           => "/etc/puppetdb/ssl/public.pem",
    ssl_key            => "/etc/puppetdb/ssl/private.pem",
    ssl_listen_address => "0.0.0.0",
  }

  include twitch_puppetdb::monitoring

  # Force Puppet's SSL configuration? Probably not idempotent.
  #exec { "/usr/sbin/puppetdb ssl-setup -f": }
}
