class twitch_puppetdb::monitoring {
  # Dependencies for the check scripts
  $_check_deps = [
    'libjson-perl',
    'libwww-perl',
    'libnagios-plugin-perl',
  ]

  package { $_check_deps:
    ensure => 'installed',
  }

  $_check_folder = '/opt/nagios_checks/puppetdb'
  file { $_check_folder:
    ensure  => 'directory',
    owner   => 'root',
    group   => 'nagios',
    mode    => '0750',
    source  => "puppet:///modules/${module_name}/check_scripts",
    recurse => true,
  }

  twitch_nagios::service {'puppetdb_memory':
    is_nrpe     => true,
    command     => "${_check_folder}/check_puppetdb_memory -H localhost -p 8080 -w 90 -c 95",
    description => 'PuppetDB Memory',
  }

  twitch_nagios::service {'puppetdb_queue':
    is_nrpe     => true,
    command     => "${_check_folder}/check_puppetdb_queue -H localhost -p 8080 -w 100 -c 200",
    description => 'PuppetDB Command Queue',
  }
}
