class twitch_python::pip::graphite_api (
  $pip_name   = 'graphite-api',
  $ensure     = '1.0.1',
  $virtualenv = 'system',
  $owner      = 'root',
) {

  package { 'libffi-dev':
    ensure => 'installed'
  }

  ::python::pip{ $pip_name:
    ensure     => $ensure,
    virtualenv => $virtualenv,
    owner      => $owner,
    require    => [Class['twitch_core::packages::python'], Package['libffi-dev']]
  }
}
