class twitch_rabbitmq::cluster {
  if $twitch_rabbitmq::autocluster {
    validate_string($twitch_rabbitmq::cluster_name)
    # We can't use $::rabbitmq::plugin_dir here, since the ${version} string
    # is interpolated in rabbitmq::params, where our "version" override hasn't
    # happened yet. :(
    $plugin_dir = "/usr/lib/rabbitmq/lib/rabbitmq_server-${twitch_rabbitmq::version}/plugins"
    $autocluster_file = "${plugin_dir}/autocluster-0.4.1.ez"

    # https://github.com/aweber/rabbitmq-autocluster
    file { $autocluster_file:
      ensure  => 'file',
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      notify  => Class['rabbitmq::service'],
      require => Class['rabbitmq::install'],
      source  => "puppet:///modules/${module_name}/autocluster-0.4.1.ez"
    }

    rabbitmq_plugin {'autocluster':
      ensure  => 'present',
      require => File[$autocluster_file],
    }
  }
}
