class twitch_rabbitmq::install inherits twitch_rabbitmq::params {
  validate_bool($twitch_rabbitmq::cluster)
  if $twitch_rabbitmq::cluster {
    validate_array($twitch_rabbitmq::cluster_nodes)
    validate_string($twitch_rabbitmq::cluster_name)
    $node_type = 'disk'
  } else {
    $node_type = undef
  }

  # We use a custom template here (`config =>`) because we need to include
  # autoclustering configuration if that's enabled, but the config supplied
  # by the OS module doesn't include a way to do that.
  class {'rabbitmq':
    version                  => $twitch_rabbitmq::version,
    # TEMP: Fix for version and package version being slightly different...
    package_ensure           => "${twitch_rabbitmq::version}-1",
    config                   => "${module_name}/rabbitmq.config.erb",
    config_cluster           => $twitch_rabbitmq::cluster,
    cluster_nodes            => $twitch_rabbitmq::cluster_nodes,
    cluster_node_type        => $node_type,
    erlang_cookie            => $twitch_rabbitmq::cluster_name,
    wipe_db_on_cookie_change => true,
    config_variables         => {
      'vm_memory_high_watermark' => '0.80',
      'heartbeat'                => 60,
      'hipe_compile'             => true,
    },
  }
}
