class twitch_rabbitmq::monitoring {
  $check_file = '/opt/nagios_checks/check_rabbitmq.py'
  file { $check_file:
    ensure => 'file',
    source => "puppet:///modules/${module_name}/check_rabbitmq.py",
    owner  => 'root',
    group  => 'nagios',
    mode   => '0750',
  }

  # Memory and swap
  twitch_nagios::service {'rabbitmq_queue':
    is_nrpe     => true,
    command     => "${check_file} -a queues_count -W 10000 -C 100000",
    description => 'RabbitMQ Queues',
    nrpe_sudo   => true,
    use     => 'generic-systems-service',
  }
}
