class twitch_rabbitmq::resources (
  $admin_password_key = 'syseng/syslog/production/rabbitmq-admin',
) {
  if $twitch_rabbitmq::exchanges {
    create_resources('rabbitmq_exchange', $twitch_rabbitmq::exchanges)
  }

  if $twitch_rabbitmq::queues {
    create_resources('rabbitmq_queue', $twitch_rabbitmq::queues)
  }

  if $twitch_rabbitmq::bindings {
    create_resources('rabbitmq_binding', $twitch_rabbitmq::bindings)
  }

  $real_users = merge($twitch_rabbitmq::users,{
    'admin' => {
      'password_key' => $admin_password_key,
    }
  })

  create_resources('twitch_rabbitmq::user', $real_users)

  if $twitch_rabbitmq::permissions {
    create_resources('rabbitmq_user_permissions', $twitch_rabbitmq::permissions, {
      require => Twitch_rabbitmq::User[keys($real_users)],
    })
  }

  if $twitch_rabbitmq::policies {
    create_resources('rabbitmq_policy', $twitch_rabbitmq::policies)
  }

  if $twitch_rabbitmq::plugins {
    create_resources('rabbitmq_plugin', $twitch_rabbitmq::plugins)
  }
}
