class twitch_sandstorm_agent::config inherits twitch_sandstorm_agent {

  file { $config_dir:
     ensure => directory,
   }

  file { $confd_dir:
    ensure => directory,
    purge => true,
    recurse => true,
  }

  file { $templates_dir:
    ensure  => directory,
    require => [
      File[$config_dir],
    ],
    purge => true,
    notify  => [
      Service['monit-sandstorm-agent'],
    ],
    recurse => true,
  }

  file { $env_dir:
    ensure  => directory,
    owner   => root,
    group   => root,
    mode    => 0555,
    require => [
      File[$config_dir],
    ],
  }

  # this is a hack to use a ~/.aws/credentials file until we figure out IAM
  file {"${env_dir}/HOME":
    ensure => present,
    require => File[$env_dir],
    content => template("${module_name}/env_home.erb"),
  }

  # Remove old single-file config so we can replace it with the new thing.
  file { $old_config_file:
    ensure => 'absent',
  }

  file { $config_file:
    ensure  => present,
    content => template("${module_name}/config.erb"),
    require => File[$old_config_file],
    notify  => [
      Service['monit-sandstorm-agent'],
    ],
  }
}
