class twitch_sandstorm_agent (
  $consul_environment = $twitch_sandstorm_agent::params::consul_environment,
  $package_name = $twitch_sandstorm_agent::params::package_name,
  $config_dir = $twitch_sandstorm_agent::params::config_dir,
  $env_dir = $twitch_sandstorm_agent::params::env_dir,
  $dwell = $twitch_sandstorm_agent::params::dwell,
  $role = $twitch_sandstorm_agent::params::role,
  $topic_arn = $twitch_sandstorm_agent::params::topic_arn,
  $key_id = $twitch_sandstorm_agent::params::key_id,
  $table_name = $twitch_sandstorm_agent::params::table_name,
  $role_arn = $twitch_sandstorm_agent::params::role_arn,
  $region = $twitch_sandstorm_agent::params::region,
  $splay = $twitch_sandstorm_agent::params::splay,
  $port = $twitch_sandstorm_agent::params::port,
  $backoff_multiplier = $twitch_sandstorm_agent::params::backoff_multiplier,
  $max_wait_time = $twitch_sandstorm_agent::params::max_wait_time,

) inherits twitch_sandstorm_agent::params {

  anchor { "${module_name}::start": } ->
  class { "${module_name}::config": } ->
  class { "${module_name}::install": } ->
  class { "${module_name}::service": } ->
  anchor { "${module_name}::end": }

  # Outside anchor pattern to avoid dependency cyclerino
  class { "${module_name}::hiera": }
  class { "${module_name}::consul": }

}
