class twitch_sandstorm_agent::params {
  $service_name = 'sandstorm-agent'
  $package_name = $service_name

  # agent config
  $config_dir = '/etc/sandstorm-agent'
  $env_dir = "${config_dir}/env"
  $templates_dir = "${config_dir}/templates.d"
  $confd_dir = "${config_dir}/conf.d"
  $config_file = "${confd_dir}/01-config.conf"
  $old_config_file = "${config_dir}/config"

  #exec options
  $exec_reload = "${service_name}/reload"
  $exec_stop = "${service_name}/stop"

  # sandstorm commands
  $sandstorm_agent_bin = "/usr/bin/sandstorm-agent"
  $sandstorm_agent_pidfile = '/var/run/sandstorm-agent.pid'
  $sandstorm_agent_user = 'root'
  $sandstorm_base_cmd = "test -f /etc/profile.d/proxy.sh && . /etc/profile.d/proxy.sh; ${sandstorm_agent_bin}"
  $sandstorm_run_cmd = "${sandstorm_base_cmd} run ${config_dir}"
  $sandstorm_daemon_cmd = "${sandstorm_base_cmd} watch ${config_dir}"
  $sandstorm_reload_cmd = 'kill -1 $(cat /var/run/sandstorm-agent.pid)'
  $sandstorm_status_cmd = 'kill -0 $(cat /var/run/sandstorm-agent.pid)'
  $sandstorm_kill_cmd   = 'kill -9 $(cat /var/run/sandstorm-agent.pid)'

  # consul
  $consul_environment = 'production'

  # agent config options
  $dwell = 20
  $role = 'none'
  $topic_arn = 'arn:aws:sns:us-west-2:734326455073:sandstorm-production'
  $key_id = 'alias/sandstorm-production'
  $table_name = 'sandstorm-production'
  $role_arn = 'default'
  $region = 'us-west-2'
  $splay = 1
  $logging = true
  $port = 7331
  $backoff_multiplier = 2
  $max_wait_time = 60
}
