class twitch_sandstorm_agent::service inherits twitch_sandstorm_agent {
  exec { $exec_stop:
    command => '/usr/bin/monit stop sandstorm-agent',
    cwd         => '/root',
    environment => ['HOME=/root'],
    refreshonly => true,
    require     => [
      Package[$package_name],
      # require monit package so command returns 0,1 as expected
      Package['monit'],
    ],
    returns => [
      0,
      1,
    ],
    before => [
      Service['monit-sandstorm-agent'],
      # before service monit so it stops the SSA agent before attempting to reload monit
      # which causes start-stop behavior
      Service['monit'],
    ]
  }

  service { "monit-sandstorm-agent":
    provider  => 'base',
    hasstatus => false,
    ensure    => 'running',
    restart   => $sandstorm_reload_cmd,
    start     => "/usr/bin/monit start sandstorm-agent",
    status    => $sandstorm_status_cmd,
    stop      => "/usr/bin/monit stop sandstorm-agent",
    require   => Service['monit'],
  }
}
