class twitch_scalerino () {
  consul::service { 'scalerino':
    consul_tags    => [$::twitch_environment],
  }

  file{ '/etc/init.d/scalerino':
    mode    => 0755,
    owner   => 'root',
    group   => 'root',
    source  => "puppet:///modules/${module_name}/scalerino.conf",
  }

  service { 'scalerino':
    ensure  => 'running',
    enable  => true,
    start   => 'sudo svc -u scalerino',
    stop    => 'sudo svc -d scalerino',
    require => File['/etc/init.d/scalerino']
  }
}
