class twitch_statsd_relay::config inherits twitch_statsd_relay {

  file { '/etc/statsd/config.js':
    ensure  => 'present',
    owner   => 'statsd',
    group   => 'statsd',
    mode    => '0644',
    content => template("${module_name}/config.js.erb")
  }

  file { '/lib/systemd/system/go-statsd-proxy.service':
    ensure  => file,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => file("${module_name}/go-statsd-proxy.service"),
  }

  sysctl::value { 'net.core.rmem_max':
    value => '134217728',
  }

  sysctl::value { 'net.core.rmem_default':
    value => '134217728',
  }

}
